import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/data.dart';
import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/user_editor_page.dart';

class UserDisplaySection extends StatelessWidget {
  const UserDisplaySection({Key? key}) : super(key: key);

  @override
  build(context) {
    return UserEditorPage(
      heading: 'Display information',
      description: "Information that's public to other users.",
      fields: [
        UserField(
          key: UserTable.displayName,
          type: FieldType.text,
          leading: 'Display name',
          placeholder: 'Display name',
        ),
        UserField(
          key: UserTable.displayWeb,
          type: FieldType.text,
          leading: 'Display web',
          placeholder: 'Web address',
        ),
        UserField(
          key: UserTable.displayBio,
          type: FieldType.textarea,
          leading: 'Display bio',
          placeholder: 'User bio',
        ),
      ],
    );
  }
}
